#!/bin/ch
/* Ch toolkit install script in Ch
=======================================================================

                         Ch Toolkit
               Proprietary and Confidential Information

 This material contains, and is part of a computer software program
 which is, proprietary and confidential information owned by 
 SoftIntegration, Inc.  The program, including this material,
 may not be duplicated, disclosed or reproduced in whole or in part for
 any purpose without the express written authorization of 
 SoftIntegration, Inc. All authorized reproductions must be marked with 
 this legend.

                       Copyright (c) 2001-2002
                        SoftIntegration, Inc.
                         All rights reserved
========================================================================

       install.ch -- Install Ch toolkit 

       Use:  ch  ./install.ch
       Description:    This script installs Ch toolkit on a Unix machine
*/
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#define NUMTRYTIMES 3   /* maximum number of try */

string_t PACKAGE="chtoolkit.bin";
string_t PRODUCT="Ch toolkit";
string_t VERSION;
char check;
int flag, numtrytimes;
char command_dir[512];
string_t gzip_str;
string_t tar_str;
string_t user;
string_t cmd;
string_t ch_home;

/* Get installation directory for ch toolkit */
ch_home=getenv("CHHOME");
if (ch_home==NULL) {
   printf("Sorry, CHHOME cannot be found\n");
   printf("Please install Ch first from http://www.softintegration.com\n");
   exit(0);
}

cmd = `ch -rv`;
if(strstr(cmd, "ERROR")) {
   printf("Error: The Ch version installed is too old for this toolkit, please download a new version from http://www.softintegration.com\n");
   exit(0);
}

if(access(PACKAGE, R_OK))  {
   printf("Error: %s cannot be found.\n");  
   printf("       It might have been removed after the first successful installation.\n");
   printf("       You may need to unpack the downloaded file again for reinstallation\n");
   exit(-1);
}

/* check for write permission */
if(access(ch_home, W_OK)) {/* writable ? */
   fprintf(stderr, "You have no write permision in the Ch home directory\n");
   fprintf(stderr, "%s to install this toolkit.\n", ch_home);
   exit(1);
}

fprintf stdout << END_FILE
==================================================================

                         Ch Toolkit Installation
             Copyright (c) 2001-2002 by SoftIntegration, Inc.

==================================================================


BY INSTALLING THIS SOFTWARE YOU ARE CONSENTING TO BE BOUND BY
AND ARE BECOMING A PARTY TO THE AGREEMENT FOUND IN THE
FOLLOWING LICENSE FILE. IF YOU DO NOT AGREE TO ALL OF THE TERMS
OF THIS AGREEMENT, PLEASE DO NOT INSTALL OR USE THIS SOFTWARE.

END_FILE

echo ""
echo ""
if(!access("./license.txt", R_OK)) {
  more ./license.txt
}
else if (!access("./license", R_OK)) {
  more ./license
}

printf("Do you agree to the license terms? (y/n)[n] ");

scanf("%c", &check);
if (!(check=='y' || check == 'Y')) {
  exit(1);
}

/* Create license */
if(!access("license.gen", R_OK&X_OK))  {
  if(system("./license.gen") != 0) { 
     exit(-1);
  }
}

if(!access("README", R_OK) || !access("README.install", R_OK)) {
  //To be 100% sure we can find gzip to extract the file.
  gzip_str=`which gzip`;
  flag=1;
  numtrytimes =1;
  while (flag== 1) {
    if (access(gzip_str, X_OK)) /* No for executable */
    {   
      if(numtrytimes <NUMTRYTIMES) {
        numtrytimes++;
        printf("\n Unable to locate 'gzip' in your path.\n");
        printf(" Please provide the fully-qualified directory in which it can be found.\n");
        printf(" Directory containing the 'gzip' binary: ");
        do {
          fgets(command_dir, 500, stdin);
        } while(strlen(command_dir) == 1 ); /* get rid of '\n'  */
        command_dir[strlen(command_dir)-1] = '\0'; /* change '\n' to '\0' */
        gzip_str=strcat(command_dir, "/gzip");
      }
      else {
        printf(" Unable to local 'gzip', please try again after you have installed gzip\n");
        exit(1);
      }
    }
    else
    {
      flag=0;
    }
  }
}

//To be 100% sure we can find the executable tar to extract the file.
flag=1;
numtrytimes =1;
tar_str=`which tar`;
while (flag== 1) {
    if (access(tar_str, X_OK)) /* No for executable */
    {
      if(numtrytimes <NUMTRYTIMES) {
        numtrytimes++;
        printf("\n Unable to locate 'tar' in your path.\n");
        printf(" Please provide the fully-qualified directory in which it can be found.\n");
        printf(" Directory containing the 'tar' binary: ");
        do {
          fgets(command_dir, 500, stdin);
        } while(strlen(command_dir) != 1 ); /* get rid of '\n'  */
        command_dir[strlen(command_dir)-1] = '\0'; /* change '\n' to '\0' */
        tar_str=strcat(command_dir, "/tar");
      }
      else {
        printf(" Unable to locate  'tar', please try again after you have installed tar\n");
        exit(1);
      }
    }
    else
    {
      flag=0;
    }
}           

fprintf stdout << END

Installing a $PRODUCT to $ch_home now, please wait ...

END

if(!access("README", R_OK) || !access("README.install", R_OK)) {
  cmd = stradd(gzip_str," -dc ", PACKAGE," | (cd ", ch_home, ";", tar_str, " -xmf -)");
}
else {
  cmd = stradd("cat ", PACKAGE," | (cd ", ch_home, ";", tar_str, " -xmf -)");
}
system(cmd);

/* To make the Linux DLL works under different std++ version */
if(!strcmp(`uname`, "Linux") && !access("/usr/lib/libstdc++-libc6.2-2.so.3", F_OK)) {
    if(!access(stradd(ch_home,"/toolkit/dl/libcgi6_2.dl"), F_OK)) {
      /bin/mv $(stradd(ch_home,"/toolkit/dl/libcgi6_2.dl")) $(stradd(ch_home,"/toolkit/dl/libcgi.dl"))
    }
    if(!access(stradd(ch_home,"/toolkit/dl/libwcgi6_2.dl"), F_OK)) {
      /bin/mv $(stradd(ch_home,"/toolkit/dl/libwcgi6_2.dl")) $(stradd(ch_home,"/toolkit/dl/libwcgi.dl"))
    }
}

/* run ranlib for Ch SDK and Embedded Ch SDK libraries for Mac if necessary */
#ifdef _DARWIN_
    if(!access(stradd(ch_home,"/extern/lib/libch.a"), F_OK)) {
      ranlib  $(stradd(ch_home,"/extern/lib/libch.a"))
    }
    if(!access(stradd(ch_home,"/extern/lib/libchsdk.a"), F_OK)) {
      ranlib  $(stradd(ch_home,"/extern/lib/libchsdk.a"))
    }
    if(!access(stradd(ch_home,"/extern/lib/libembedch.a"), F_OK)) {
      ranlib  $(stradd(ch_home,"/extern/lib/libembedch.a"))
    }
#endif

/* Create license */
if(!access("license.gen", R_OK&X_OK))  {
  if(!access("/tmp/ChToolkit_license.key", R_OK)) {
    /bin/cat /tmp/ChToolkit_license.key >> $(ch_home)/toolkit/license/license.key
  }
  //else {
  //  printf("Error: failed to generate license file \n");
  //}
}

fprintf stdout << END
Files has been successfully installed.
A $PRODUCT installation is complete. 
Garbage cleaning begins ... 
END

if(!access("README", R_OK) || !access("README.install", R_OK)) {
  /bin/rm -f $PACKAGE;
  /bin/rm -f install.ch;
  if(!access("license.gen", R_OK&X_OK))  {
    /bin/rm -f license.gen
  }
}

printf("\nGarbage cleaning ends  ... \n"); 

printf("\n\nPlease read %s/toolkit/README \n", ch_home); 
printf("Please try demo programs for this toolkit in %s/toolkit/demos \n", ch_home); 
exit(0);
