/* Filename: embedch3.c */
#include <embedch.h>
#include <stdio.h>

/* original C function */ 
int func(double x, int n, int *a) {
    int i;
    
    printf("x = %f\n", x);
    for(i=0; i<n; i++) 
       printf("a[%d] = %d\n", i, a[i]); 
    a[0] = 100;  /* change element a[0] in the Ch space */
    return 0;
}

/* interface to func() */
EXPORTCH int func_chdl(void *varg) {
    ChInterp_t interp;
    ChVaList_t ap;
    double x;
    int n, *a;
    int retval;
    
    Ch_VaStart(interp, ap, varg);
    x = Ch_VaArg(interp, ap, double);
    n = Ch_VaArg(interp, ap, int);
    a = Ch_VaArg(interp, ap, int *);
    retval = func(x, n, a);
    Ch_VaEnd(interp, ap);
    return retval;
}

int main() { 
  ChInterp_t interp;
  char *argvv[]={"embedch3.ch", NULL};
  
  /* initialize embedded Ch */
  Ch_Initialize(&interp, NULL);
  
  /* declare function func() in the Ch space */
  Ch_DeclareFunc(interp, "int func(double x, int n, int *a);", func_chdl);
  
  /* run an embedded Ch program (embedch3.ch) indicated by argvv */
  Ch_RunScript(interp,  argvv);
  
  /* release memory and terminate the shell */
  Ch_End(interp);
  return 0;
}
